<?php

use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Permission;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $guard = config('auth.defaults.guard', 'web');

        $statuses = [
            'requested',
            'quoted',
            'for_approval',
            'for_product_creation',
            'request_transfer',
            'transfer_approved',
            'approved',
            'rejected',
        ];

        foreach ($statuses as $status) {
            Permission::findOrCreate("purchase_requisition.status.$status", $guard);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // No-op: keep permissions on rollback to avoid breaking role references.
    }
};

